//
//  ViewController.m
//  Citizen PSamle 1
//
//  Created by Member Driver on 12/11/19.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

@synthesize editText_Address_Wifi;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    // manage keyboard
    editText_Address_Wifi.returnKeyType = UIReturnKeyDone;
    editText_Address_Wifi.delegate = self;
    
    segmentPortType.selectedSegmentIndex = 0;
    
    editText_Address_Wifi.text = @"";       // clear IP address
} 

- (void)dealloc
{
    // release object
    [editText_Address_Wifi release];
    [segmentPortType release];
    
    [super dealloc];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        //return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
        return YES;
    } else {
        return YES;
    }
}

- (void)messageBox:(NSString *)message withTitle:(NSString *)title withAutoDismiss:(BOOL)dismiss
{
    if (!dismiss)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [alert show];
        [alert release];
    }
    else
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:nil otherButtonTitles:nil];
        [alert show];
        [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:1.5]];    // wait 1.5 sec
        [alert dismissWithClickedButtonIndex:0 animated:NO];
        [alert release];
    }
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [editText_Address_Wifi resignFirstResponder];
    return YES;
}

//
// Sample Print 1 Button
//
- (IBAction)onClick_button_SamplePrint01_Wifi:(id)sender
{
    posPtr = [[ESCPOSPrinter alloc] init];
    
    // get address
    NSString *addr = editText_Address_Wifi.text;
    
    // connect
    int result;
    if (0 == segmentPortType.selectedSegmentIndex)
    {
        result = [posPtr connect:CMP_PORT_BLUETOOTH withAddrress:addr];
    }
    else
    {
        result = [posPtr connect:CMP_PORT_WiFi withAddrress:addr];
    }
    if (CMP_SUCCESS == result)
    {
        // character set
        [posPtr setEncoding:NSISOLatin1StringEncoding]; // latin-1
        //[posPtr setEncoding:NSShiftJISStringEncoding];    // japanese shift-jis
        
        // start transaction (batch)
        [posPtr transactionPrint:CMP_TP_TRANSACTION];
        
        // printText
        NSString *appName = [NSString stringWithFormat:@"%@\n\n", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleDisplayName"]];
        [posPtr printText:appName withAlignment:CMP_ALIGNMENT_CENTER withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT];
        [posPtr printText:@"- Sample Print 1 -\n" withAlignment:CMP_ALIGNMENT_CENTER withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_2HEIGHT];
        [posPtr printText:@"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n" withAlignment:CMP_ALIGNMENT_RIGHT withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT];
        
        //printQRCode
        [posPtr printQRCode:@"http://www.citizen-systems.co.jp" withModuleSize:6 withECLevel:CMP_QRCODE_EC_LEVEL_L withAlignment:CMP_ALIGNMENT_RIGHT];
            
        // partical cut with pre-feed
        [posPtr cutPaper:CMP_CUT_PARTIAL_PREFEED];
        
        // end transaction (batch)
        result = [posPtr transactionPrint:CMP_TP_NORMAL];
        
        // discoonect
        [posPtr disconnect];

        if (CMP_SUCCESS != result)
        {
            // transaction error
            NSString *message = [NSString stringWithFormat:@"Transaction Error : %d", result];
            [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
        }
    }
    else
    {
        // connect error
        NSString *message = [NSString stringWithFormat:@"Connect or Printer Error : %d", result];
        [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
    }
    [posPtr release];
}

//
// Sample Print 2 Button - for 3 inches paper
//
- (IBAction)onClick_button_SamplePrint02_Wifi:(id)sender
{
    posPtr = [[ESCPOSPrinter alloc] init];

    // get address
    NSString *addr = editText_Address_Wifi.text;
    
    // connect
    int result;
    if (0 == segmentPortType.selectedSegmentIndex)
    {
        result = [posPtr connect:CMP_PORT_BLUETOOTH withAddrress:addr];
    }
    else
    {
        result = [posPtr connect:CMP_PORT_WiFi withAddrress:addr];
    }
    if (CMP_SUCCESS == result)
    {
        // character set
        [posPtr setEncoding:NSISOLatin1StringEncoding]; // latin-1
        //[posPtr setEncoding:NSShiftJISStringEncoding];    // japanese shift-jis
        
        // start transaction (batch)
        [posPtr transactionPrint:CMP_TP_TRANSACTION];
        
        // print normal
        NSString *appName = [NSString stringWithFormat:@"%@\n\n", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleDisplayName"]];
        [posPtr printText:appName withAlignment:CMP_ALIGNMENT_CENTER withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT];
        NSString *sample2 = [NSString stringWithFormat:@"%c|2vC%c|cA- Sample Print 2 -\n", 27, 27];
        [posPtr printNormal:sample2];
        [posPtr printText:@"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n" withAlignment:CMP_ALIGNMENT_RIGHT withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT];
        
        // start page mode
        [posPtr pageModePrint:CMP_PM_PAGE_MODE ];
        
        // set offset value in pagemode
        [posPtr setPageModeVerticalPosition:0];
        [posPtr setPageModeHorizontalPosition:0];
        
        // set print direction in pagemode
        [posPtr setPageModePrintDirection:CMP_PD_TOP_TO_BOTTOM];
        
        // set printable area in pagemode
        [posPtr setPageModePrintArea:@"500,0,76,800" ];
        
        NSString *receipt = [NSString stringWithFormat:@"%c|4C- Receipt -\n", 27];
        [posPtr printNormal:receipt];
        [posPtr setPageModePrintArea:@"260,0,120,800" ];
        [posPtr printText: @"$ 299.99- \n" withAlignment:CMP_ALIGNMENT_CENTER withAttribute:CMP_FNT_UNDERLINE|CMP_FNT_BOLD withTextSize:CMP_TXT_4WIDTH|CMP_TXT_4HEIGHT];
        [posPtr setPageModePrintArea:@"88,0,88,560" ];
        [posPtr printText: @" CITIZEN SYSTEMS\n" withAlignment:CMP_ALIGNMENT_RIGHT withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_2WIDTH|CMP_TXT_3HEIGHT];
        //[posPtr setPageModePrintArea: @"0,0,88,480" ];
        [posPtr setPageModePrintArea: @"0,0,98,480" ];
        [posPtr printBarCode:@"123456789012" withSymbology:CMP_BCS_UPCA withHeight: 64 withWidth:4 withAlignment:CMP_ALIGNMENT_LEFT
                withTextPosition:CMP_HRI_TEXT_BELOW];
        [posPtr setPageModePrintArea: @"0,600,192,192" ];
        [posPtr printQRCode:@"http://www.citizen-systems.co.jp/" withModuleSize :5 withECLevel:CMP_QRCODE_EC_LEVEL_L withAlignment:CMP_ALIGNMENT_LEFT];
        
        // end page mode
        [posPtr pageModePrint:CMP_PM_NORMAL ];
            
        // partical cut with pre-feed
        [posPtr cutPaper:CMP_CUT_PARTIAL_PREFEED];
            
        // end transaction (batch)
        result = [posPtr transactionPrint:CMP_TP_NORMAL];
        
        // discoonect
        [posPtr disconnect];

        if (CMP_SUCCESS != result)
        {
            // transaction error
            NSString *message = [NSString stringWithFormat:@"Transaction Error : %d", result];
            [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
        }
    }
    else
    {
        // connect error
        NSString *message = [NSString stringWithFormat:@"Connect or Printer Error : %d", result];
        [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
    }
    [posPtr release];
}

@end
